{*************************************************************************
 * Program Name : ASCIITable - Version 1.0(beta)                         *
 * (c): Marcel Vander Mierde                                             *
 *      Created       19-11-1999                                         *
 *      Last modified 30-11-1999                                         *
 *                                                                       *
 *      Genkersteenweg 395                                               *
 *      B-3500 HASSELT                                                   *
 *      BELGIUM                                                          *
 *      +32 11 72 84 43                                                  *
 *                                                                       *
 *      EMail Marcel.Vander.Mierde@PANDORA.BE                            *
 *                                                                       *
 * This Program displays the ASCII Table on the screen                   *
 *  while the user can scroll up and downwards by line or by page        *
 *                                                                       *
 *************************************************************************

 *************************************************************************
 *                                                                       *
 * This program is written in Borland Pascal 7.0 so adapt if needed      *
 * Places where I would like some help:                                  *
 * -Hiding the cursor (I am not familiar with assembler code)            *
 * -General advice on enhancing this code                                *
 *                                                                       *
 *************************************************************************

 *************************************************************************
 * Some explanation concerning used abreviations and variable-names      *
 * My variables usually start with :                                     *
 * i : for Integer : is : for ShortInt                                   *
 *                   il : for LongInt                                    *
 *                   ib : for Byte                                       *
 *                   iw : for Word                                       *
 *                                                                       *
 * r : for Real    : rs : for Single                                     *
 *                   rd : for Double                                     *
 *                   re : for Extended                                   *
 *                   rc : for Comp                                       *
 *                                                                       *
 * s : for String                                                        *
 *                                                                       *
 * b : for Boolean                                                       *
 *                                                                       *
 * c : for Char                                                          *
 *                                                                       *
 * a : for Array                                                         *
 *                                                                       *
 * This initial abreviation is then usually followed by the name         *
 *  of the variable (where I always try to give something meaningfull)   *
 *                                                                       *
 * A permanent piece of comment always stands between braces,            *
 *  while an outcommented block of code stands between                   *
 *  paranthese/asterisk and asterisk/paranthese                          *
 *  See also the help files of Pascal                                    *
 *************************************************************************

 *************************************************************************
 * I also have a certain locgic in building my programs                  *
 * The BEGIN .. END Routine of a program which has to stand at the       *
 *  end, just contains one call: Main                                    *
 *                                                                       *
 * The 'Main' of a program always stands at the begin of a module        *
 *  and only contains calls to other procedures and functions            *
 * The next section contains the procedures and functions for the        *
 *  different screens and InputFields                                    *
 * The last section contains the procedures and functions common to      *
 *  the complete program                                                 *
 *                                                                       *
 * Therefore however, every function and procedure has to be declared    *
 *  as 'Forward' in the beginning of the program itself.                 *
 *                                                                       *
 * A tip :                                                               *
 * -------                                                               *
 * The only way to write a good program is to read someone else's code   *
 *  and adapt it to to your own needs.                                   *
 * That's the way I work, and it has saved me a lot of time              *
 *                                                                       *
 * Therefore I always try to declare my variables, procedures and        *
 *  functions as readable and meaningfull text                           *
 * So feel free to use and adapt my code to your own needs,              *
 * The only thing I ask for is, that if you enhance my code, you should  *
 *  give me a sign, so i can adopt these changes into my code also       *
 *  or start a discussion over the reason of my code                     *
 *                                                                       *
 *************************************************************************

 *************************************************************************
 *Important Notice about the DELAY procedure                             *
 *------------------------------------------                             *
 *There is a difference in calculating the milliseconds, so one should   *
 * first convert the value to be appropriate to the Pascal version one   *
 * is using.                                                             *
 *************************************************************************

 *************************************************************************}
PROGRAM ASCIITbl;

{*************************************************************************
 Declare Libraries to use
 *************************************************************************}
 Uses CRT, {Catode Ray Tube
            Needed for Input from and Output to screen}
      DOS; {DiskOperatingSystem Functions and procedures
            Needed for Date and Time Functions}

{*************************************************************************}


{*************************************************************************
 Declaring procedures forward
 ----------------------------
 This makes it possible to use procedures and function before they have
  been read by the program
 *************************************************************************}
 Procedure Center(sString      : String;
                  iScreenWidth : Integer); Forward;

 Procedure InitVars; Forward;

 Procedure FillASCIITable; Forward;

 Procedure MakeBasicScreen; Forward;

 Procedure MakeNoise; Forward;

 Procedure MakeScreen; Forward;

 Procedure UpdateDTG; Forward;

 Procedure WaitReply; Forward;

 Procedure WriteASCIITable; Forward;

 Procedure WriteField(iX      : Integer;
                      iY      : Integer;
                      iLength : Integer); Forward;

 Procedure WriteOn(iX : Integer;
                   iY : Integer;
                   sString : String); Forward;

 Function LeadingZeroes(iWord      : Word;
                        iMaxLength : Integer) : String; Forward;

 Function Char2Bin(cPassedChar : Char) : String; Forward;

 Function Char2Hex(cPassedChar : Char) : String; Forward;

 Function LTrim(passedString : String) : String; Forward;

 Function RTrim(passedString : String) : String; Forward;

 Function Trim(passedString : String) : String; Forward;

 Function Val2Bin(ilPassedValue : LongInt) : String; Forward;

 Function Val2Hex(ilPassedValue : LongInt) : String; Forward;

{*************************************************************************
 Declaring Program Type Variables
 ----------------------------------}
 Type
   tASCIILine = Record
                   sASCIICode : String[3];
                   cASCIIChar : Char;
                   sBinCode   : String[8];
                   sHexCode   : String[2];
                End;

{*************************************************************************
 Declaring Global Program Variables
 ----------------------------------}
 VAR sScrTopLine     : String; {General Variables}
     sScrEmptyLine   : String;
     sScrFullLine    : String;
     sScrBtmLine     : String;
     bProgramDone    : Boolean;
     sProgramName    : String;
     ibTextBkground  : Byte;   {Color Variables}
     ibTextColor     : Byte;
     ibFieldBkground : Byte;
     ibFieldColor    : Byte;
                               {Program specific variables}
     aASCIITable     : Array[0 .. 255] Of tASCIILine;
     ibIndex         : Byte;
     bChar7On        : Boolean;


{End Declaring Variables
 *************************************************************************}


{*************************************************************************}
 Procedure Main;{
 ----------------
 In fact this Procedure constitutes the program on itself
 The BEGIN .. END routine on the End of the Program,
  just calls this Procedure
 The Program starts to read the instructions here
 *************************************************************************}
{No local variables needed}

 BEGIN

{Variables are declared at the top,
 so we can initialize them}
 Initvars;

{Paint the Screen for this program}
 MakeScreen;


{Fill the aASCIITable array}
 FillASCIITable;

{Show results on screen and wait for input from the user}
 Repeat
    BEGIN
      WriteASCIITable;
     {Wait for the user to do something}
      WaitReply;
    END;
 Until bProgramDone;

{Reset colors
 This can be achieved in two ways
 Either by calling the NormVideo procedure from CRT}
 NormVideo;

 {Either by resetting the colors manually:
  TextBackGround(BLACK);
  TextColor(WHITE);}

 {Clear Screen}
  ClrScr;

 END;{Program
 *************************************************************************}


{*************************************************************************}
 Procedure Center(sString      : String;
                  iScreenWidth : Integer);{
 ----------------------------------------
 Procedure 'typing' a text centered on the current line of the screen
 It does so by subtracting the length of the passed string from
 the passed Maximum length or the screenwidth (normaly 80 characters)
 and dividing the remainder by 2
 It then puts the string on the calculated position of the current line
 The current line can be found by the function 'WhereY'

 PROCEDURE STILL UNDER TEST

 *************************************************************************}
{Declare local needed variables}
 VAR iStartX  : Integer;
     iStartY  : Integer;
     sTempStr : String;
     sRestStr : String;
     iPos     : Integer;

 BEGIN
   {Initialize local variables}
    sTempStr := '';
    sRestStr := sString;
    iPos     := 0;

   {Check current Line}
    iStartY := WhereY;

   {Check passed parameters}
    If iScreenWidth > 80 then
       iScreenWidth := 80;

   {Start loop}
    While Length(sRestStr) > 0 do
       BEGIN
         {Check remaining characters}
          If Length(sRestStr) < iScreenWidth then
             BEGIN
                sTempStr := sRestStr;
                sRestStr := '';
             END
          Else
             BEGIN
               {Search a character where we can split the string
                Start searching at the last possible character, and
                scan forwards,
                This code still has to be adopted for small values of
                iScreenWidth}
                For iPos := iScreenWidth DownTo 1 Do
                    BEGIN
                      {Read character}
                       If (sRestStr[iPos] <> ' ') OR
                          (sRestStr[iPos] <> '-') then
                          {The char on iPos is in a word, so we can not split
                           Decrement value of iPos,
                           automatically with For .. DownTo .. Do}
                       Else
                          BEGIN
                            {Split the string
                             I have done this by:
                              copying the characters from the string with the remaining characters
                              to the temporary string,
                              and then deleting those characters from the remainder string}
                             sTempStr := Copy(sRestStr, 1, iPos);
                             Delete(sRestStr,1, iPos);
                             iPos := 1; {Set iPos to 1 to exit the loop}
                          END;
                    END;
             END;
          iStartX := (iScreenWidth - Length(sTempStr)) DIV 2;
          GoToXY(iStartX,iStartY); Write(sTempStr);
          iStartY := iStartY +1;
       END;

 END; {Procedure Center
 *************************************************************************}


{*************************************************************************}
 Procedure FillASCIITable;{
 --------------------------
 Procedure filling the ASCIITable array with the different values
 *************************************************************************}
{Declare local variables}
VAR ibASCIICode : Byte;

 BEGIN
  For ibASCIICode := 0 To 255 Do
      With aASCIITable[ibASCIICode] do
           BEGIN
              sASCIICode := LeadingZeroes(ibASCIICode,3);
              cASCIIChar := Char(ibASCIICode);
              sBinCode := Char2Bin(cASCIIChar);
              sHexCode := Char2Hex(cASCIIChar);
           END;

 END; {Procedure FillASCIITable
 *************************************************************************}


{*************************************************************************}
 Procedure InitVars;{
 --------------------
 Procedure putting some initial values in declared variables
 *************************************************************************}
 BEGIN
    sScrTopLine     :='ͻ';
    sScrEmptyLine   :='                                                                             ';
    sScrFullLine    :='͹';
    sScrBtmLine     :='ͼ';
    bProgramDone    := False;
    sProgramName    := 'Scrollable ASCII Table';

    ibTextBkground  := LIGHTGRAY;
    ibTextColor     := BLUE;
    ibFieldBkground := RED;
    ibFieldColor    := YELLOW;

    ibIndex         := 0;
    bChar7On        := False;

 END; {Procedure InitVars
 *************************************************************************}


{*************************************************************************}
 Procedure MakeBasicScreen;{
 ---------------------------
 Procedure prepares basic screen
 This should normally be inserted into a library, and be called from there
 *************************************************************************}
{Declare local needed variables}
 VAR iLine : Integer;  {iLine stands for the linenumber on the screen}

 BEGIN
   {Put Colors before preparing Screen}
    TextBackground(ibTextBkground);
    TextColor(ibTextColor);

   {Clear the screen}
    ClrScr; {Clear Screan from CRT}

   {Now 'paint' a nice looking screen for the user}
    GoToXY(1,1);  WriteLn(sScrTopLine);
    FOR iLine := 2 to 23 Do
       BEGIN
          GoToXY(1,iLine);
          WriteLn(sScrEmptyLine);
       END;
    GoToXY(1,3);  WriteLn(sScrFullLine);
    GoToXY(1,22); Writeln(sScrFullLine);
    GoToXY(1,24); WriteLn(sScrBtmLine);
    GoToXY(1,22); TextColor(RED);
                  Center('Instructions',80);
                  TextColor(BLUE);

    UpdateDTG;
  (*UpdateStatus;*)

 END; {MakeBasicScreen
 *************************************************************************}


{*************************************************************************}
 Procedure MakeNoise;{
 ---------------------
 Procedure holding different routines to make a certain noise
 *************************************************************************}
{Declare local needed variables}
 VAR iFreq : Integer;

 BEGIN
    For iFreq := 1 to 25 do
        BEGIN
           Sound(iFreq * 100);
           Delay(500);
           NoSound;
        END;

 END; {Procedure MakeNoise
 *************************************************************************}


{*************************************************************************}
 Procedure MakeScreen;{
 ----------------------
 Procedure prepares screen specific to this program
 *************************************************************************}
{No local variables needed}

 BEGIN
   {Initialize Local Variables}

   {Paint the Basic Screen}
    MakeBasicScreen;
   {Paint the Title}
    GotoXY(1,2); Center(sProgramName, 80);
   {Remove the line with the mention 'Instructions' from the basicscreen}
    WriteOn(1,22, sScrEmptyLine);
   {Now write the instructions for using this scrollable list}
    TextColor(RED);
    WriteOn(50,5,'I N S T R U C T I O N S');
    GotoXY(50,7) ; Write('Line Up         :  ',Chr(24));
    GotoXY(50,8) ; Write('Line Down       :  ',Chr(25));
    GotoXY(50,9) ; Write('Page Up         :  PageUp');
    GotoXY(50,10); Write('Page Down       :  PageDwn');
    GotoXY(50,11); Write('Begin list      :  Home');
    GotoXY(50,12); Write('End List        :  End');
    GotoXY(50,14); Write('Print Chr #7 On :  Y');
    GotoXY(50,15); Write('Print Chr #7 Of :  N');
    GotoXY(50,17); Write('Stop            :  Esc');
   {Reset Color}
    TextColor(BLUE);

 END; {MakeScreen
 *************************************************************************}


{*************************************************************************}
 Procedure UpdateDTG;{
 ---------------------
 Procedure updating the Date and Time Group on the screen
 See Help on GetDate and GetTime
 Therefore we need DOS

 PROCEDURE STILL UNDER CONSTRUCTION
 INTENT TO INCORPORATE THIS IN A UNIT AND USE MORE FUNCTIONS WITH PARAMETERS

 *************************************************************************}
{Declare local needed variables}
 CONST
    DayName : Array [0..6] of String[9] =
              ('Sunday',
               'Monday',
               'Tuesday',
               'Wednesday',
               'Thursday',
               'Friday',
               'Saturday');

 VAR iwDay      : Word; {These variables are all    }
     iwMonth    : Word; {needed to call the           }
     iwYear     : Word; {GetDate  and GetTime Procedures from DOS   }
     iwWeekDay  : Word; {They must be declared as Word}
     iwHours    : Word;
     iwMinutes  : Word;
     iwSeconds  : Word;
     iwHundreds : Word;

     sDate      : String;
     sYear      : String;
     sMonth     : String;
     sDay       : String;
     sWeekDay   : String;
     sTime      : String;
     sHours     : String;
     sMinutes   : String;
     sSeconds   : String;

{Start Main routine of UpDateDTG}
 BEGIN
 {Get the SystemDate - Therefore we need DOS}
  GetDate(iwYear,iwMonth,iwDay,iwWeekDay);
 {Convert Integer values to Strings}
  Str(iwYear, sYear);
  sMonth := LeadingZeroes(iwMonth,2);
  sDay   := LeadingZeroes(iwDay,2);
  sWeekDay := DayName[iwWeekday];
 {Concatenate different strings to Date string- European type}
  sDate := sWeekday + ' '
           + sDay + '/'
           + sMonth + '/'
           + sYear;
  WriteOn(3,1,sDate);

 {Get the SystemTime}
  GetTime(iwHours,iwMinutes,iwSeconds,iwHundreds);
 {Convert Integer values to Strings}
  sHours   := LeadingZeroes(iwHours,2);
  sMinutes := LeadingZeroes(iwMinutes,2);
  sSeconds := LeadingZeroes(iwSeconds,2);
 {Concatenate different strings to Time string}
  sTime :=   sHours + ':'
           + sMinutes + ':'
           + sSeconds;
  WriteOn(70,1,sTime);

 END;{Procedure UpdateDTG
 *************************************************************************}


{*************************************************************************}
 Procedure WaitReply;{
 ---------------------
 Procedure Asking the user to press a key mentioned in the displayed line
 and acting acordingly
 *************************************************************************}
{Declare needed local variables}
VAR cKeyPressed :Char;

 BEGIN

   {Start Loop}
    Repeat
      BEGIN
        {Update Date and Time Group on the screen}
         UpdateDTG;
      END;
    Until Keypressed;

   {If a key was pressed}
    If KeyPressed then
      {Check which one}
       BEGIN
       cKeyPressed := ReadKey;
       If cKeyPressed = Chr(0) then
          BEGIN
             CASE ReadKey OF
                 'G': {Home}
                      ibIndex := 0;
                 #72: {LineUp - user is browsing up line by line}
                      BEGIN
                         If ibIndex > 0 then
                            ibIndex := ibIndex - 1
                         Else
                            If ibIndex <> 0 then
                               ibIndex := 0;
                      END;
                 #73: {PageUp - User is browsing up page by page}
                      BEGIN
                         If ibIndex >= 15 then {could use > 14}
                            ibIndex := ibIndex - 15
                         Else
                            If ibIndex <> 0 then
                               ibIndex := 0;
                      END;
                 #79: {End - User has chosen to go to the end of the table}
                      ibIndex := 241;
                 #80: {LineDown - User is browsing down line by line}
                      BEGIN
                         If ibIndex <= 240 then  {could use < 241}
                            ibIndex := ibIndex  + 1
                         Else
                            If ibIndex <> 241 then
                               ibIndex := 241;
                      END;
                 #81: {PageDown - User is scrolling down the list by page}
                      BEGIN
                         If ibIndex < 226 then {two pages before end of list}
                            ibIndex := ibIndex + 15
                         Else
                            If ibIndex <> 241 then
                               ibIndex := 241;
                      END
             END;{Case}
          END
       Else
          CASE ckeyPressed OF
               'y', 'Y': {User wants Chr#7 to be printed}
                   bChar7On := True;
               'n', 'N': {User does not want Chr#7 to be printed}
                   bChar7On := False;
               #27:  {if ESCAPE was pressed}
                   bProgramDone := True;
                   END;
      {End If}
    END;

 END; {Procedure WaitReply
 *************************************************************************}

{*************************************************************************}
 Procedure WriteASCIITable;{
 ---------------------------
 Procedure showing

 *************************************************************************}
{Declare local needed variables}
 VAR iLine : Byte;

 BEGIN
    WriteOn(5, 5, ' ASCIICode  Char  Bin Code  HexCode ');
    WriteOn(5, 6, '͹');
    WriteOn(5,22, 'ͼ');

    For iLine := 7 to 21 Do
        BEGIN
           GotoXY(5,iLine);
           With aASCIITable[ibIndex] do
                BEGIN
                   GotoXY( 5,iLine); Write('');
                   GotoXY(10,iLine); Write(sASCIICode);
                   GotoXY(17,iLine); Write('');
                   If bChar7On then
                     {We can print all characters without distinction}
                     {We will have to notice that on the place of cASCIIChar
                      nothing will be printed on screen}
                      BEGIN
                         GotoXY(20,iLine); Write(cASCIIChar);
                         If cASCIIChar = #7 then
                            BEGIN
                               GotoXY(20,iLine); Write(Char(0));
                            END
                      END
                   Else
                      If cASCIIChar <> #7 then
                         BEGIN
                            GotoXY(20,iLine); Write(cASCIIChar);
                         END
                      Else {If cASCIIChar <> #7 then}
                         BEGIN
                            GotoXY(20,iLine); Write(Char(0));
                         END;
                   GotoXY(24,iLine); Write('');
                   GotoXY(26,iLine); Write(sBinCode);
                   GotoXY(35,iLine); Write('');
                   GotoXY(39,iLine); Write(shexCode);
                   GotoXY(45,iLine); Write('');
                END;
           If ibIndex <> 255 then {prevent returning to the first ibIndex}
              ibIndex := ibIndex +1
        END;

   {Reset ibIndex to index from first line}
    If ibIndex >= 15 then
       ibIndex := ibIndex - 15

 END; {Procedure WriteASCIITable
 *************************************************************************}


{*************************************************************************}
 Procedure WriteField(iX      : Integer;
                      iY      : Integer;
                      iLength : Integer);{
 -----------------------------------------
 Procedure painting some regions on the screen in a specific color
 so the user immediatly sees where he has to put his input
 Procedure takes different parameters:
 iX and iY to locate startposition on the screen
 iLength to determine the number of positions to set
 *************************************************************************}
{Declare local needed variables}
 VAR sString : String;
     iPos    : Integer;

 BEGIN
    {Compose the String}
     sString := '';
     For iPos := 1 to iLength do
         sString := sString + ' ';

    {Set Field colors}
     TextBackground(ibFieldBkground);
     TextColor(ibFieldColor);

    {Write the string}
     GoToXY(iX,iY);
     Write(sString: iLength);

    {ResetColors}
     TextBackground(ibtextBkground);
     TextColor(ibTextColor);

 END;{Procedure WriteField
 *************************************************************************}


{*************************************************************************}
 Procedure WriteOn(iX : Integer;
                   iY : Integer;
                   sString : String);{
 -------------------------------------
 Because I was tired of coding each time:
 GoToXY(Column,Line); Write('A String')
 I have created my own procedure to combine these 2 commands.
 So, instead of typing all this, I now type:
 WriteOn(Column,Line,'A String');
 The only disadvantage of this routine is that one can not give more than
 one string, so if one wants to put a composed string on the screen, he has:
 - either to use the commands "GoToXY" and "Write"
 - either by composig the string first in a variable and then use this
   procedure with the variable
 *************************************************************************}
{No local variables needed}

 BEGIN
    GoToXY(iX,iY);
    Write(sString);

 END; {Procedure WriteOn
 *************************************************************************}


{*************************************************************************}
 Function Char2Bin(cPassedChar : Char) : String;{
 -----------------------------------------------
 Function converting a passed variable of type Character
 to a Binary string,
 Function takes a Character as parameter and returns a string
 function is called as follows :
 aBinString := Char2Bin(cCharacter);
 *************************************************************************}
{Declare local needed variables}
 VAR sRetStr : String;

 BEGIN
   {Initialize variables each time the function is called}
    sRetStr  := '';

   {Call Val2Bin Function}
    sRetStr := Val2bin(Ord(cPassedChar));

   {Because we want an output in 8 positions}
    While length(sRetStr) < 8 do
          sRetStr := '0' + sRetStr;

   {Finally return sRetStr}
    Char2Bin := sRetStr;

 END; {Function Char2Bin
 *************************************************************************}


{*************************************************************************}
 Function Char2Hex(cPassedChar : Char) : String;{
 ------------------------------------------------
 Function converting a passed variable of type Character
 to a Binary string,
 Function takes a Character as parameter and returns a string
 function is called as follows :
 aHexString := Char2Hex(cCharacter);
 *************************************************************************}
{Declare local needed variables}
 VAR sRetStr  : String;

 BEGIN
   {Initialize variables each time the function is called}
    sRetStr  := '';

   {Call Val2Hex Function}
    sRetStr := Val2Hex(Ord(cPassedChar));

   {Because we want an output in 2 positions}
    While length(sRetStr) < 2 do
          sRetStr := '0' + sRetStr;

   {Finally return sRetStr}
    Char2hex := sRetStr;

 END; {Function Char2Hex
 *************************************************************************}


{*************************************************************************}
 Function LeadingZeroes(iWord : Word;
                        iMaxLength : Integer) : String;{
 -------------------------------------------------------
 Function taking an Integer of type Word (for date and time functions)
 and returning the passd value with a the needed leading zeros
 *************************************************************************}
{Declare local needed variables}
 VAR sRetStr : String;

 BEGIN
    Str(iWord:0,sRetstr);
    While Length(sRetstr) < iMaxLength Do
       sRetStr := '0' + sRetStr;
    LeadingZeroes := sRetStr;

 END;{Function LeadingZeroes
 *************************************************************************}


{*************************************************************************}
 Function LTrim(passedString : String) : String;{
 -------------------------------------------
 Function removing all leading spaces from a passed string
 Function is called as follows:
 passedString := LTrim(passedString);
 *************************************************************************}
{No local variables needed}

 BEGIN
     LTrim := passedString; {Clear remaining memory trash by assigning
                        the passed string to the function}
     While passedString[1] = ' ' do      {as long as first character is a space}
        Begin
          If passedString ='' Then Exit;    {if passedString should be empty, exit to prevent eternal loop}
          Delete(passedString,1,1);         {remove first character}
          LTrim := passedString;            {put modified string into function}
        End;
 END; {Function LTrim
 *************************************************************************}


{*************************************************************************}
 Function RTrim(passedString : String) : String;{
 ------------------------------------------
 Function removing all trailing spaces from a passed string
 Function is called as follows:
 passedString := RTrim(passedString);
 *************************************************************************}
{No local variables needed}

 BEGIN
    RTrim := passedString;
    While passedString[Length(passedString)] = ' ' do
       Begin
          If Length(passedString) = 0 Then Exit;
          Delete(passedString,Length(passedString),1);
          RTrim := passedString;
       End;

 END; {Function RTrim
 *************************************************************************}


{*************************************************************************}
 Function Trim(passedString : String) : String;{
 ----------------------------------------------
 Function removing all leading and trailing spaces from a passed string
 Function is called as follows:
 someString := Trim(someString);
 *************************************************************************}
{No local variables needed}

 BEGIN
    Trim := passedString;
    While passedString[1] = ' ' do
       Begin
          If Length(passedString) = 0 Then Exit;
          Delete(passedString,1,1);
          Trim := passedString;
       End;
    While passedString[Length(passedString)] = ' ' do
       Begin
          If Length(passedString) = 0 Then Exit;
          Delete(passedString,Length(passedString),1);
          Trim := passedString;
       End;
 END; {Function Trim
 *************************************************************************}


{*************************************************************************}
 Function Val2Bin(ilPassedValue : LongInt) : String;{
 ---------------------------------------------------
 Function converting a passed variable of type longInt
 to a Binary string,
 Function takes a LongInt Value as parameter and returns a string
 function is called as follows :
 aBinString := Byte2Bin(ibValue);
 *************************************************************************
{Declare local needed variables}
 VAR sRetStr    : String;
     sTempStr   : String;
     iRest      : Integer;
     ilFigure   : LongInt;

 BEGIN
   {Initialize variables each time the function is called}
    sRetStr  := '';
    sTempStr := '';
    iRest    := 0;
    ilfigure := 0;

   {Put passed value into local variable}
    ilfigure := ilPassedValue;
   {Start loop}
    Repeat
       iRest := ilFigure MOD 2;
       Str(iRest,sTempStr);
       sRetStr := sTempStr + sRetStr;
       ilFigure := ilFigure - iRest;
       ilFigure := ilFigure DIV 2;
    Until ilFigure = 0;

   {Finally return sRetStr}
    Val2Bin := sRetStr;

 END; {Function Val2Bin
 *************************************************************************}


{*************************************************************************}
 Function Val2Hex(ilPassedValue : LongInt) : String;{
 ----------------------------------------------------
 Function converting a passed variable of type LongInt
 into a HexaDecimal string,
 Function takes a LongInt as parameter and returns a string
 function is called as follows :
 aHexString := Val2Hex(iLongInt);
 *************************************************************************}
{Declare local needed variables}
 VAR sRetStr  : String;
     sTempStr : String;
     iRest    : Integer;
     ilFigure : LongInt;

 BEGIN
   {Initialize variables each time we call the function}
    sRetStr  := '';
    sTempStr := '';
    iRest    := 0;
    ilFigure := 0;

   {Put passed value into local variable}
    ilFigure := ilPassedValue;

    Repeat
       iRest := ilFigure MOD 16;
      {Because hexaDecimal code is a special representation of
       numeric values, we have to store the result in a temporary string}
       Case iRest of
          0 : sTempStr := '0';
          1 : sTempStr := '1';
          2 : sTempStr := '2';
          3 : sTempStr := '3';
          4 : sTempStr := '4';
          5 : sTempStr := '5';
          6 : sTempStr := '6';
          7 : sTempStr := '7';
          8 : sTempStr := '8';
          9 : sTempStr := '9';
         10 : sTempStr := 'A';
         11 : sTempStr := 'B';
         12 : sTempStr := 'C';
         13 : sTempStr := 'D';
         14 : sTempStr := 'E';
         15 : sTempStr := 'F';
       End;
       sRetStr := sTempStr + sRetStr;
       ilFigure := ilFigure - iRest;
       ilFigure := ilFigure DIV 16;
    Until ilFigure = 0;

   {Finally return sRetStr}
    Val2Hex := sRetStr;

 END; {Function Val2Hex
 *************************************************************************}



{*************************************************************************
 *************************************************************************}
 BEGIN{
 ------
 The Program starts to read the instructions here
 *************************************************************************
 Just execute the Main Procedure}

 Main;

 END.{Program
 *************************************************************************
 *************************************************************************}

