{Try this.. I haven't tested it very extensively yet, but it should do the 
trick quite nicely.  Anyone can feel free to use it, just read through it 
and figure out what you're doing first.  Don't use the write routine 
unless you're sure you know how, I only tested it on a diskette drive, my 
hard-drive wasn't worth trying it on until I have a good use for it.
Distribute as you will, but don't charge any money for it.
}

unit biosdisk;
 
interface
const
 {drive number codes}
  adrive = $00;
  bdrive = $01;
  cdrive = $80;
  ddrive = $81;
  edrive = $82;
 {disk status codes}
  noerror = 0;
  badcommand = 1;
  badsector = 2;
  writeprotected = 3;
  sectornotfound = 4;
  diskchange = 6;
  invalidmedia = $0C;
  contollererror = $20;
  seekfailure = $40;
  timeout = $80;
 
type
  tsector = array[0..512] of byte;
  psector = ^tsector;
 
function diskstatus: byte;
procedure resetdisk(drive:byte);
function getcx(sector,track:word):word;
procedure readsector(drive:byte; sector,track,head:word; dest:psector);
procedure writesector(drive:byte; sector,track,head:word; dest:psector);
 
implementation
{-----------------------------}
function diskstatus: byte;
begin
  asm
    push ds             {save ds}
    mov ah, 1
    int 13h
    mov @result, al
    pop ds
  end;  {asm}
end;  {diskstatus}
{-----------------------------}
procedure resetdisk(drive: byte);
begin
  asm
    push ds             {save ds}
    xor ah, ah
    mov dl, drive
    int 13h
    pop ds
  end;  {asm}
end;  {resetdisk}
{-----------------------------}
function getcx(sector,track: word): word;
var
  tcx: word;
begin
  tcx:= 0;
  sector:= sector AND NOT $3F;    {set sector bits}
  tcx:= tcx OR sector;
 
  if (track AND $100) = $100 then {set track bits}
    tcx:= tcx OR $40;
  if (track AND $200) = $200 then
    tcx:= tcx OR $80;
  tcx:= tcx OR (track SHL 8);
 
  getcx:= tcx;
end;
{-----------------------------}
procedure readsector(drive:byte; sector,track,head:word; dest:psector);
var
        tcx: word;
begin
        tcx:= getcx(sector,track);
        resetdisk(drive);
        asm
                push ds           {save ds}
                mov ah, 2         {BIOS disk read}
                mov al, 1         {read 1 sector}
                mov dl, drive     {from drive}
                mov cx, tcx       {sector & track #}
                mov bx, head      {head # (drop high byte)}
                mov dh, bl
                les bx, dest      {to here}
                int 13h
                pop ds            {restore ds}
         end;  {asm}
end;  {readsector}
{-----------------------------}
procedure writesector(drive:byte; sector,track,head:word; dest:psector);
var
        tcx: word;
begin
        tcx:= getcx(sector,track);
        resetdisk(drive);
        asm
                push ds           {save ds}
                mov ah, 3         {BIOS disk write}
                mov al, 1         {write 1 sector}
                mov dl, drive     {to drive}
                mov cx, tcx       {sector & track #}
                mov bx, head      {head # (drop high byte)}
                mov dh, bl
                les bx, dest      {from here}
                int 13h
                pop ds            {restore ds}
        end;  {asm}
end;  {writesector}
{-----------------------------}
End.  {biosdisk}
