Program CursorSize;
{TP 7.0}
{Uses interrupt 10h Video, function 01h.}
Uses Crt, Dos;
Var
  FontHeight: byte;       {Number of scan lines from the on screen
font.}
  Startline, EndLine: byte;        {Start and end scan lines for
cursor.}
  Regs: Registers;
  Bit6Response: char;

Begin
  Clrscr;
  FontHeight := Mem[$0040:$0085] - 1;
  Writeln ('Display mode (LastMode) = ', LastMode);
  Write ('Switch start scan line bit 6 on Y/N?');
  Repeat Bit6Response := Upcase(Readkey)
  until Bit6Response in ['Y','N'];
  Writeln (Bit6Response);

  Repeat
   Writeln;
   {Set cursor start and end scan lines. }
   Write ('Enter cursor start scan line (0..',FontHeight,') : ');
   Readln (StartLine);
   Write ('Enter cursor  end  scan line (0..',FontHeight,') : ');
   Readln (EndLine);
   Regs.AH := $01;
   Regs.CH := StartLine;       {The upper scan line of the cursor
block.}
   Regs.CL := EndLine;         {The lower scan line of the cursor
block.}
   {Bits 5 and 6 of the byte that contains the start scan line,
    control the cursor's behaviour.}
   {Switch bit 5 off, to make the cursor visible.    20h = bit 5.}
   Regs.CH := Regs.CH and not $20;
   {This next action is not documented, but setting bit 6 seems to
    to give the program perfect control over the cursor size !!!}
   {Switch bit 6 on, to enable cursor sizing.        40h = bit 6.}
   If Bit6Response = 'Y' then Regs.CH := Regs.CH or $40;
   Regs.AL := LastMode;         {To avoid bug in some 386 BIOSes.}
   Intr($10,Regs);

   {Display the cursor along side a full height, #219 block
    character, for easy confirmation of cursor size.}
   Write ('Press any key to continue (ESC to quit) '#219);
  until Readkey = #27;        {ESC = #27.}
end.
