{LCHA41B@prodigy.com wrote:

> I've been working on some routines to gather data about the disk drives
> currently installed on a system, but there doesn't seem to be much
> available in the way of system resources for this task.  My current

Try this little piece of code... It will detect drive types. The only  
thing is: I don't know how to detect RAM drives (they are detected as  
hard disk drives).

-- Matthias
}

const
  dtInvalid = 0;
  dtFloppy = 1;
  dtHardDisk = 2;
  dtRamDrive = 3;
  dtNetDrive = 4;
  dtSubstDrive = 5;
  dtCDROM = 6;

function DriveValid(Drive: Char): Boolean; near; assembler;
asm
	MOV	AH,19H          { Save the current drive in BL }
	INT	21H
	MOV	BL,AL
	MOV	DL,Drive	{ Select the given drive }
	SUB	DL,'A'
	MOV	AH,0EH
	INT	21H
	MOV	AH,19H		{ Retrieve what DOS thinks is current }
	INT	21H
	MOV	CX,0		{ Assume false }
	CMP	AL,DL		{ Is the current drive the given drive? }
	JNE	@@1
	MOV	CX,1		{ It is, so the drive is valid }
	MOV	DL,BL		{ Restore the old drive }
	MOV	AH,0EH
	INT	21H
@@1:	XCHG	AX,CX		{ Put the return value into AX }
end;

function IsCDRom(Drive: Char): Boolean; near; assembler;
var
  map: array[0..25] of Byte;
asm
	mov	bx, ss
	mov	es, bx
	lea	bx, map
	mov	di, bx
	cld
	mov	cx, 26/2
	mov	ax, 0FFFFH
	rep	stosw
	mov	ax, 150DH
	int	2FH
	lea	di, map
	mov	al, 1		{ Assume it is a CD ROM }
	mov	dh, Drive
	sub	dh, 'A'
@@1:
	mov	dl, es:[bx]
	cmp	dl, dh
	jz	@@0		{ Found drive letter }
	inc	dl
	jz	@@2		{ End of list }
	inc	bx
	jmp	@@1
@@2:
	mov	al, 0
@@0:
end;

function IsFixed(Drive: Char): Boolean; near; assembler;
asm
	mov	ax, 4408H
	mov	bl, Drive
	sub	bl, 'A' - 1
	int	21H
	jnc	@@0
	mov	al, 1		{ On error assume it's fixed }
@@0:
end;

function IsRemote(Drive: Char): Boolean; near; assembler;
asm
	mov	ax, 4409H
	mov	bl, Drive
	sub	bl, 'A' - 1
	int	21H
	mov	al, 0		{ Assume it's not remote }
	jc	@@0
	shr	dx, 12		{ Get bit 12 }
	mov	al, dl
	and	al, 1
@@0:
end;

function IsSubst(Drive: Char): Boolean; near; assembler;
asm
	mov	ax, 4409H
	mov	bl, Drive
	sub	bl, 'A' - 1
	int	21H
	mov	al, 0		{ Assume it's not remote }
	jc	@@0
	shr	dx, 15		{ Get bit 15 }
	mov	al, dl
	and	al, 1
@@0:
end;

function GetDriveType(Drive: Char): Byte;
begin
  GetDriveType := dtInvalid;
  if DriveValid(Drive) then
    if IsSubst(Drive) then GetDriveType := dtSubstDrive else
    if IsRemote(Drive) then GetDriveType := dtNetDrive else
    if IsCDROM(Drive) then GetDriveType := dtCDROM else
    if IsFixed(Drive) then GetDriveType := dtHardDisk else
    GetDriveType := dtFloppy
end;


Matthias Koeppe              (currently out of witty quotes)
mkoeppe@moose.boerde.de
100331.174@compuserve.com
## CrossPoint v3.02 ##
