Unit frp_key;
{keyboard unit}
{$V-,R-,S-}

{$IFDEF DPMI}
  Yell! Don Not compile With DPMI!! Not tested yet!!!
{$ENDIF}

Interface

Type BufSize = 0..127;

Procedure PutBuffer (stx: String);
Procedure PutBufferScan (keycode,scancode : byte);

Function  GetBufSize: BufSize;
Procedure SetBufSize (Size: BufSize);
Procedure ClearBuffer;

Implementation

Const Segm   = $0040; { segment adress of GetPnt etc. }
      GetPnt = $001A; { adresses of various pointers concerning the }
      PutPnt = $001C; { keyboard buffer }
      OldAdr = $001E;
      NewAdr = $0134;
      BegBuf = $0080;
      EndBuf = $0082;

Var Buffer: Word;

Procedure ClearBuffer;
{ Sets GetPnt and PutPnt to beginning of buffer, which will result in
  erasing all current keystrokes }

Begin
  MemW [Segm: PutPnt] := Buffer;
  MemW [Segm: GetPnt] := Buffer
End;

Procedure SetBufSize (Size: BufSize);
{ This procedure sets the size of the keyboard-buffer, max. = 127 }

Begin
  Case Size Of
    1..15: Buffer := OldAdr; {no need to change here}
    16..127: Buffer := NewAdr;
  End;
  MemW [Segm: BegBuf] := Buffer;
  MemW [Segm: EndBuf] := Buffer + (2 * Size) + 2;
  ClearBuffer; {since we changed it, we must clean it up}
End;

Function GetBufSize: BufSize;

Begin
  GetBufSize := ( (MemW [Segm: EndBuf] - MemW [Segm: BegBuf] ) Div 2) - 1 End;


Procedure PutBuffer (stx: String);
{ This procedure puts the given string into the keyboard-buffer. If there's
  no room in the buffer for the entire string, only part of string is copied
  (no overflow will occur, it'll simple stop copying
}

Var i, j, avail: Byte; {avail is 0..127, so byte is enough}

Begin
  i := 1; j := 0;
  avail := GetBufSize;
  While (i <= Length (stx) ) And (i < Avail) Do
  Begin
    Mem [Segm: Buffer + j] := Ord (stx [i] ); {put keycode}
    Mem [Segm: Buffer + j + 1] := 0;          {ignore scancode}
    Inc (i);
    j := j + 2;
  End;
  Dec (i); {we entered i-1 keys into the stack}
  MemW [Segm: PutPnt] := Buffer + (i * 2); {update pointer stuff}
  MemW [Segm: GetPnt] := Buffer
End;

Procedure PutBufferScan (keycode,scancode : byte);
{ puts keycode AND scancode as provided by the user in the buffer }

Var i, j, avail: Byte; {avail is 0..127, so byte is enough}

Begin
  i := 1; j := 0;
  avail := GetBufSize;
  While (i <= 1 ) And (i < Avail) Do
  Begin
    Mem [Segm: Buffer + j] := keycode; {put keycode}
    Mem [Segm: Buffer + j + 1] := scancode;          {ignore scancode}
    Inc (i);
    j := j + 2;
  End;
  Dec (i); {we entered i-1 keys into the stack}
  MemW [Segm: PutPnt] := Buffer + (i * 2); {update pointer stuff}
  MemW [Segm: GetPnt] := Buffer
End;

Begin {unit}
  SetBufSize (127); {set buffer to max}
End.

Have a nice day...

frans@frp.idn.nl
--
| Standard disclaimer: The views of this user are strictly his own.
