{$R-}
UNIT FWrite;
{ ************************************************************
  Module: UNIT FWRITE
  File  : FWRITE.pas
  Date  : 23.9.94
  Author: Rubenking

  used units: crt
  used files: none

  2x faster Write-routines

  ************************************************************}

INTERFACE
var
  ScreenWidth,
  ScreenHeight : Byte;

  Procedure FastWrite(S: String; co, ro, at: Byte);
  Procedure FasterWrite(S: String; co, ro, at: Word);
  Procedure CheckWidthHeight;

IMPLEMENTATION
uses crt;
Type
  WordArray = Array[0..65520 DIV 2] of word;
VAR
  Display :^WordArray;
  Crt_Cols: Word ABSOLUTE $40:$4A;
  Crt_Rows: Word ABSOLUTE $40:$84;

procedure FastWrite;
var
  Start, WordAttr: Word;
  N: Byte;
begin
  Start:=pred(ro)*Screenwidth+pred(co);
  wordAttr:=Word(At) shl 8;
  for n:=1 to ord(S[0]) do
    Display^[start+pred(N)]:=WordAttr+ord(S[N]);
end;

procedure FasterWrite(S: String; co, ro, at: word); assembler;
asm
  mov ax, ro;
  dec al;
  shl al,1;
  mul screenwidth;
  add ax,co;
  dec ax;
  mov di,word(display);
  add di, ax;
  mov ax,word(Display+2);
  mov es, ax;
  push ds;
  lds si,s;
  xor cx,cx;
  mov cl, [si];
  inc si;
  mov bh, Byte(At)
  @Loop:
    movsb;
    mov es:[di], bh;
    inc di;
  loop @loop;
  pop ds
end;

procedure checkwidthheight;
begin
  ScreenWidth:=Crt_Cols;
  ScreenHeight:=Succ(Crt_Rows);
end;

begin
  CheckWidthHeight;
  if LastMode = 7 then display:=PTR($B000,0)
    else Display:=PTR($B800,0);
end.
