{
      A pair of diodes are necesary:
         - An infra-red emmiter LED.
         - A infrared receiver diode.

infrared LED must be conected to bit 5 of the parallel port (pin 7)
receiver diode must be conected to pin 12 of the parallel port
of course, two diodes must be conected to ground (pin 20).

with this simple circuit you can control any infraredm device (TVs,etc)


Unit:        IRU
Version:     1.0=B7

Description: This unit allows you to control infrared devices, such as
               TVs, videos, etc., simply putting a pair of diodes in the
               parallel port.

Date:        December, 1995.

Programmed by: MACRO    (macro@policc.unex.es)

You can use and modify this code on your programs,
but remember to give me credit :-)
}

unit iru;

interface

const IRcodeLength=3D300; {Memory in bytes for each code,
                         can be increased to obtain more resolution}
      rate=3D20;          {Is a delay that defines the sample frequency,
                         20 value works well in a DX2, must be
                         decreased for slower systems}


type IRcode=3Darray[1..IRcodeLength] of byte;

procedure receiveIRcode(var x:IRcode);
{  This procedure waits until a IR code is received, then hold
 it in 'x' IRcode type variable.
   Be sure of put the emitter LED very close to the receiver DIODE.}

procedure sendIRcode   (var x:IRcode);
{  This procedure dumps the IR code specified in 'x' thru the
 IR LED}

implementation

procedure receiveIRcode(var x:IRcode);
var i,j:word;
begin
  for i:=3D1 to IRcodeLength do x[i]:=3D0;
  repeat until (port[$379] AND 32)=3D0;
  asm cli; end;
  for i:=3D1 to IRcodeLEngth DO
  begin
    asm mov cx,rate;
        @1: in al,$61
            and al,0
            out dx,al
        loop @1 end;
    x[i]:=3Dport[$379];
  end;
  asm sti; end;
  j:=3D0; for i:=3D1 to IRcodeLength do x[i]:=3D(x[i] and 32) xor 32;
end;

procedure sendIRcode   (var x:IRcode);
var i:word; v:byte;
begin
  port[$61]:=3Dport[$61] or 1; port[$43]:=3D182;
  port[$42]:=3D30;             port[$42]:=3D0;
  for i:=3D1 to IRCodeLength DO
    begin
      v:=3Dx[i];
      asm
        mov dx,$378
        mov cx,rate
        @1: in al,$61
            and al,v
            out dx,al
            loop @1
      end;
    end;
  port[$61]:=3Dport[$61] and 252;
end;

begin
end.
