unit UCursor;
interface

type  CursorForm=(CuNone,  {hidden cursor}
                  CuLine,  {normal line cursor}
                  CuBlock, {full box cursor}
                  CuHalf); {half box cursor (like insert-cursor in DOS)}

var   cursors : array [CursorForm] of word; {MicLine from..to
                                              Hi()=from, Lo()=to}
      cuform  : CursorForm; {current cursor form}

procedure SetCursorForm(kind:CursorForm);

function  getCursorKind:word;
  {get current cursor format via Video-BIOS,
  {only for saving at program start - if neccessary}

procedure HideCursor;
  { same as SetCursorForm(cuNone) }


implementation

function  getCursorKind:word; assembler;
  asm mov ah,$03; xor bh,bh; int $10; xchg ax,cx end;

procedure setCursorKnd(w:word); assembler;
  {Set cursor form via BIOS}
  asm mov cx,w; mov ah,1; int 10h  end;

{I forgot, since when TP got an inline assembler,
may be it was 6.0. Change the asm sequence by using
INTR() if neccessary!}

function ColorBoard:boolean;
  {detect screen:Color or B/W}
  var cb:word;
  begin asm int $11; mov cb,ax end;
  ColorBoard:=cb and $30 <>$30
  end;

procedure InitCursor;
  {Set Values depending on Color- or B/W-Screen
   (different number of micLines)}
  begin
  cursors[cuNone]:=$0100 {set to $1426 if cursor will never disappear};
  if ColorBoard then {virtual MicLines 0..7}
    begin cursors[cuLine]:=$0607;
    cursors[cuBlock]:=$0007;
    cursors[cuHalf]:=$0407
    end
  else {MicLines 0..13}
    begin cursors[cuLine]:=$0c0d;
    cursors[cuBlock]:=$000d;
    cursors[cuHalf]:=$060d
    end;
  setCursorKnd(cursors[cuLine])
  end;

procedure SetCursorForm(kind:CursorForm);
  begin {Show cursor in format of kind}
  cuForm:=kind; setCursorKnd(cursors[kind])
  end;

procedure HideCursor;
  begin SetCursorForm(CuNone) end;

begin InitCursor end.
