unit Timer;

interface

  var
    TimeCounter: Word;

implementation

  uses
    DOS;

  var
    OldTimerInt: Pointer;
    OldExitProc: Pointer;

  {$F+}
  procedure NewTimerInt; assembler;
  asm
        pushf
        push    ax
        push    ds
        mov     ax, seg @Data
        mov     ds, ax
        inc     TimeCounter
        pop     ds
        pop     ax
        popf
        iret
  end;

  procedure StopTimer;
  begin
    SetIntVec ($1C, OldTimerInt);
    ExitProc := OldExitProc;
  end;
  {$F-}

begin
  TimeCounter := 0;
  GetIntVec ($1C, OldTimerInt);
  SetIntVec ($1C, Addr (NewTimerInt));
  OldExitProc := ExitProc;
  ExitProc := @StopTimer;
end.
