
(* ͻ	*)
(* 							    	*)
(* 	 Borland Pascal Programs			    	*)
(* 	 WavePlay Source Demo				    	*)
(* 	 dark - cloud programming			    	*)
(* Ķ	*)
(* 							    	*)
(* 	 Copyright (C) 1996 Diego Iastrubni		    	*)
(* 							    	*)
(* ͼ	*)
(*  	*)

Program WavePlay;

{$G+,X+,I-}

Const
  RiffSignature =  'RIFF';
  WaveSignature =  'WAVE';
  FmtSignature	=  'fmt ';
  DataSignature =  'data';

  feNoError	 =  0;
  feNotARiff	 =  1;
  feNotAWave	 =  2;
  feNotAnFMT	 =  3;
  feErrorInData  =  4;

  UsageMsg	  =  #10#13+'WAVEPLAY version 1.0, Copyright (C) 1996, Diego.'+
		     #10#13'Usage: WAVEPLAY filename[.cel].';
  NotFoundMsg	  =  'File not found. ';
  ErrorMsg	  =  'Error loading wave file - ';
  NoSoundCardMsg  =  'Sound card not found.';

  WaveExt  = '.WAV';

  TIMER_INT	=  8;
  PIT_FREQ	=  $1234DD;
  CurrClockTiks =  $10000;


Type
  Call = Procedure;

  BYTE_ARRAY	= array [0..$FFFF-1] of Byte;
  POINTER_ARRAY = ^BYTE_ARRAY;


Type
  RIFF_FILE = Record
    rID 	    : array [0..3] of char;  { Always	 "RIFF" 	 }
    rLen	    : LongInt;		     { Size of data		 }
    wID 	    : array [0..3] of char;  { Always	 "WAVE" 	 }
    fID 	    : array [0..3] of char;  { Always	 "fmt " 	 }
    fLen	    : LongInt;		     { Size of data in format	 }
    wFormatTag	    : Word;		     { *			 }
    nChannels	    : Word;		     { Number of channels	 }
    nSamplesPerSec  : Word;		     { Playback frequency	 }
    nAvgBytesPerSec : Word;		     { **			 }
    nBlockAlign     : Word;		     { ***			 }
    FormatSpecific  : Word;		     { Format specific data area }
    Dummy	    : LongInt;
    dID 	    : array [0..3] of char;  { Always	 "data" 	 }
    dLen	    : LongInt;		     { Size of data		 }
    dData	    : Pointer;		     { Actual waveform data	 }
  End;

{)

  *   The wFormatTag specifies the wave format, eg 1 = Pulse Code Modulation
      (or in plain english, regular 8 bit sampled uncompressed sound)

  **  Indicates the average number of bytes a second the data should be
      transferred at = nChannels * nSamplesPerSec * (nBitsPerSample / 8)

  *** Indicates the block alignment of the data in the data chunk. Software
      needs to process a multiplt of nBlockAlign at a time.
      nBlockAlign = nChannels * (nBitsPerSample / 8)

(}

Var
  Rif		  : RIFF_FILE;
  Clock_Ticks,
  Counter	  : Longint;
  BIOSHandler	  : Pointer;
  Timer 	  : LongInt absolute $40:$6C;
  PlaySound	  : Boolean;
  DelayCnt	  : Word;


Procedure DelayLoop; Assembler;
Asm
@@1:	SUB	AX,1
	SBB	DX,0
	JC	@@2
	CMP	BL,ES:[DI]
	JE	@@1
@@2:
End;

Procedure InitDelay; Assembler;
Asm
	MOV	ES,Seg0040
	MOV	DI,OFFSET Timer
	MOV	BL,ES:[DI]
@@2:	CMP	BL,ES:[DI]
	JE	@@2
	MOV	BL,ES:[DI]
	MOV	AX,-28
	CWD
	CALL	DelayLoop
	NOT	AX
	NOT	DX
	MOV	CX,55
	DIV	CX
	MOV	DelayCnt,AX
End;

Procedure Delay(MS: Word); Assembler;
Asm
	MOV	CX,MS
	JCXZ	@@2
	MOV	ES,Seg0040
	XOR	DI,DI
	MOV	BL,ES:[DI]
@@1:	MOV	AX,DelayCnt
	XOR	DX,DX
	CALL	DelayLoop
	LOOP	@@1
@@2:
End;

Function KeyPressed: Boolean; Assembler;
Asm
	MOV	AH,1
	INT	16H
	MOV	AL,0
	JZ	@IsNot

@IsTrue:MOV   AL,True
	JMP   @End
@IsNot: MOV   AL,False
@End:
End;

Procedure GetIntVec(IntNo: Byte; var Vector: Pointer); Assembler;
Asm
	MOV	AL,IntNo
	MOV	AH,35H
	INT	21H
	MOV	AX,ES
	LES	DI,Vector
	CLD
	XCHG	AX,BX
	STOSW
	XCHG	AX,BX
	STOSW
End;

Procedure SetIntVec(IntNo: Byte; Vector: Pointer); Assembler;
Asm
	PUSH	DS
	LDS	DX,Vector
	MOV	AL,IntNo
	MOV	AH,25H
	INT	21H
	POP	DS
End;

Function ReadKey: Char; InLine($B8/$00/$00/$CD/$16);

Function Reset_Dsp: boolean;
Begin
  Reset_dsp:= False;
  Port[$226]:= 1;
  Delay(1);

  Port[$226]:=0;
  Delay(1);
  Repeat Until Port[$22E] > $80;
  If port[$22A] = $AA Then
    Reset_Dsp:= True;
end;

Procedure Spk_On;
Begin
  Repeat Until Port[$22C] < $80;  { wait until the write reg bit 7 is off }
  Port[$22C]:= $D1;		  { then write message }
End;

Procedure Spk_Off;
Begin
  Repeat Until Port[$22C] < $80;  { wait until the write reg bit 7 is off }
  Port[$22C]:= $D3;		  { then write message }
End;

Procedure Write_Dsp(Data: Byte);
Begin
  Repeat Until Port[$22C] < $80;  { wait until the write reg bit 7 is off }
  Port[$22C]:= $10;		  { then write message }
  Repeat Until Port[$22C] < $80;  { ditto}
  Port[$22C]:= Data;
End;

Function LoadRiff( Name: String; Var Rif: RIFF_FILE ): Byte;
Var
  RiffFile: File;
Begin
  FillChar( Rif, SizeOf(Rif), 0 );
  LoadRiff:= feNoError;

  Assign( RiffFile, Name );
  Reset( RiffFile, 1 );
  BlockRead( RiffFile, Rif, 44 );

  If Rif.rID <> RiffSignature
    Then Begin
	   LoadRiff:= feNotARiff;
	   Exit;
	 End;

  If Rif.wID <> WaveSignature
    Then Begin
	   LoadRiff:= feNotAWave;
	   Exit;
	 End;

  If Rif.fID <> FmtSignature
    Then Begin
	   LoadRiff:= feNotAnFMT;
	   Exit;
	 End;

  If Rif.dID <> DataSignature
    Then Begin
	   LoadRiff:= feErrorInData;
	   Exit;
	 End;

  GetMem( Rif.dData, Rif.dLen );
  BlockRead( RiffFile, Rif.dData^, Rif.dLen );

  Close( RiffFile );
End;

Procedure PlayWaveProc; Forward;

Procedure TimerHandler(Flags, CS, IP, AX, BX,
 CX, DX, SI, DI, DS, ES, BP: Word); Interrupt;
Begin
  PlayWaveProc;

  Inc( Clock_Ticks, Counter);
  If Clock_Ticks >= CurrClockTiks
    Then Begin
	   Dec(Clock_Ticks, CurrClockTiks);
	   InLine($9C);    (* PUSHF *)
	   Call(BIOSHandler);
	 End
    Else Port[$20] := $20;
End;

Procedure InstallPitt( Hz: Word );
Begin
  Clock_Ticks:= 0;
  Counter:= PIT_FREQ div Hz;

  GetIntVec(TIMER_INT, BIOSHandler);
  SetIntVec(TIMER_INT, @TimerHandler);

  Port[$43]:= $34;
  Port[$40]:= Counter mod 256;
  Port[$40]:= Counter div 256;

  PlaySound:= True;
End;

Procedure RestorePitt;
Begin
  Port[$43] := $34;
  Port[$40] := 0;
  Port[$40] := 0;
  SetIntVec(TIMER_INT, BIOSHandler);
End;

Procedure PlayWaveProc;
Const
  Index: Word = 0;
Begin
  If PlaySound
    Then Write_Dsp(POINTER_ARRAY(Rif.dData)^[Index]);
  Inc(Index);

  If (Index = Rif.dLen)
    Then {Index:= 0; {RestorePitt; }PlaySound:= False;
End;

Function FileExist( Name: String ): Boolean;
Var
  F: File;
Begin
  Assign( F, Name );
  Reset( F );
  Close( F );
  FileExist:= IOResult=0;
End;

Var
  WaveName: String;

Begin
  If ParamStr(1) = '' Then
    Begin
      WriteLn( UsageMsg );
      Halt;
    End;

  WaveName:= ParamStr(1);

  If Not FileExist( WaveName ) Then
     Begin
       WaveName:= WaveName + WaveExt;
       If Not FileExist( WaveName ) Then Begin
	 WriteLn( NotFoundMsg, '('+ParamStr(1)+')');
	 Halt(1)
       End;
     End;

  If Reset_Dsp
    Then If LoadRiff( WaveName, Rif )<>0
	    Then WriteLn( ErrorMsg, ParamStr(1) )
	    Else Begin
		   SPK_On;
		   InstallPitt( Rif.nSamplesPerSec );
		   Repeat Until KeyPressed or Not PlaySound;
		   If KeyPressed Then ReadKey;
		   RestorePitt;
		   SPK_Off;
		 End
   Else WriteLn( NoSoundCardMsg );
End.
